    
/*******************************************************************/
/* The Wave-5 release does not include the European Values Survey. */
/* To get the earlier European countries, I need to extract them   */
/* from the Wave-4 release.                                        */
/* Note that the EVS and WVS data are not totally comparable       */
/* because of coding and naming changes from wave 4 to wave 5.     */
/* See the online documentation for more details; I deal only      */
/* with the relevant issues here.				   */
/* Refs: http://www.wvsevsdb.com/wvs/WVSFaqs.jsp		   */
/* (It is just that WVS & EVS haven't figured out licenses.)	   */
/*******************************************************************/
    
use "$directory\WVS\xwvsevs_1981_2000_v20060423.dta" if s001==1, clear
drop if s003a==752 & s002 ==4 /* This wave of Sweden is in the Wave 5 data */
foreach var of varlist a010-a019 c059 d020a{ /* change 1=yes,2= no to 1=yes, 0=no */
    recode `var' (2=0)
}
qui for X in var a124 a125 a126 a127 a128 a129 a130 a131 a132 a133 a134 a135 a136 a137 a138 a139 a140 a141 a142 a143 a144 a145 a146 a147 a148 a149 a150 a151 a152 a153 a154 a155 a156 a157 a158 a159 a160 a161 a162 a163 a164 a177 a178 a180 a182 a183 a184 a185 a186 a187 a188 c042 c043 c044 c045 c046 c047 c048 e069 e070 e071 e072 e073 e074 e075 e076 e077 e078 e079 e080 e081 e082 e083 e084 e085 e086 e087 e088 e089 e090 e091 e092 e093 e094 e095 e096 e097 e098 e099 e100 e101 e102 e103 e199 e200 e201 e202 g007 g008a g008aa g008ab g008ac g008ad g008ae g008af g008ag g008ah g008ai g008aj g008ak g008al g008am g008an g008ao g008ap g008aq g008ar g008as g008at g008au g008av g008aw g008ax g008ay g008az g008b g008ba g008bb g008bc g008c g008d g008e g008f g008g g008h g008i g008j g008k g008l g008m g008n g008o g008p g008q g008r g008s g008t g008u g008v g008w g008x g008y g008z  \ ///
	 Y in any a124_01 a124_02 a124_03 a124_04 a124_05 a124_06 a124_07 a124_08 a124_09 a124_10 a124_11 a124_12 a124_13 a124_14 a124_15 a124_16 a124_17 a124_18 a124_19 a124_20 a124_21 a124_22 a124_23 a124_24 a124_25 a124_26 a124_27 a124_28 a124_29 a124_30 a124_31 a124_32 a124_33 a124_34 a124_35 a124_36 a124_37 a124_38 a124_39 a124_40 a124_41 a124_44 a124_45 a124_46 a124_47 a124_48 a124_49 a124_50 a124_51 a124_52 a124_53 c042b1 c042b2 c042b3 c042b4 c042b5 c042b6 c042b7 e069_01 e069_02 e069_03 e069_04 e069_05 e069_06 e069_07 e069_08 e069_09 e069_10 e069_11 e069_12 e069_13 e069_14 e069_15 e069_16 e069_17 e069_18 e069_19 e069_20 e069_21 e069_22 e069_23 e069_24 e069_25 e069_26 e069_27 e069_28 e069_29 e069_30 e069_31 e069_32 e069_33 e069_34 e069_35 e069_36 e069_37 e069_38 e069_39 g007_01 g007_02 g007_03 g007_04 g007_05 g007_06 g007_07 g007_08 g007_09 g007_10 g007_11 g007_12 g007_13 g007_14 g007_15 g007_16 g007_17 g007_18 g007_19 g007_20 g007_21 g007_22 g007_23 g007_24 g007_25 g007_26 g007_27 g007_28 g007_29 g007_30 g007_31 g007_32 g007_37 g007_38 g007_39 g007_40 g007_41 g007_42 g007_43 g007_44 g007_45 g007_46 g007_47 g007_48 g007_49 g007_50 g007_51 g007_52 g007_53 g007_54 g007_55 g007_56 g007_57 g007_58 g007_59 g007_60: ///
	 rename X Y
drop y003 s007
save "$directory\WVS\evs", replace


/* Get the wave 5 release, append the EVS countries */
use "$directory/WVS/wvs1981_2008_v20090914.dta", clear
append using "$directory\WVS\evs"
duplicates tag, gen(dupe)
assert dupe == 0
drop dupe
rm "$directory\WVS\evs.dta"

keep if x003>=18 | x003==. /* Restrict sample to adults; no age codes for HUN, KOR*/
* Using s003a as the country variable: Today's countries, followed back through history.
gen str3 cty=""
replace cty="ALB" if s003a==8
replace cty="DZA" if s003a==12
replace cty="AZE" if s003a==31
replace cty="ARG" if s003a==32
replace cty="AUS" if s003a==36
replace cty="AUT" if s003a==40
replace cty="BGD" if s003a==50
replace cty="ARM" if s003a==51
replace cty="BEL" if s003a==56

replace cty="BRA" if s003a==76
replace cty="BGR" if s003a==100
replace cty="BLR" if s003a==112
replace cty="CAN" if s003a==124
replace cty="CHL" if s003a==152
replace cty="CHN" if s003a==156
replace cty="TWN" if s003a==158
replace cty="COL" if s003a==170
replace cty="HRV" if s003a==191
replace cty="CZE" if s003a==203
replace cty="DNK" if s003a==208
replace cty="DOM" if s003a==214
replace cty="SLV" if s003a==222
replace cty="EST" if s003a==233
replace cty="FIN" if s003a==246
replace cty="FRA" if s003a==250
replace cty="GEO" if s003a==268

replace cty="GRC" if s003a==300
replace cty="HUN" if s003a==348
replace cty="ISL" if s003a==352
replace cty="IND" if s003a==356
replace cty="IDN" if s003a==360
replace cty="IRN" if s003a==364
replace cty="IRQ" if s003a==368
replace cty="IRL" if s003a==372
replace cty="ISR" if s003a==376
replace cty="ITA" if s003a==380
replace cty="JPN" if s003a==392
replace cty="JOR" if s003a==400
replace cty="KOR" if s003a==410
replace cty="KGZ" if s003a==417
replace cty="LVA" if s003a==428
replace cty="LTU" if s003a==440
replace cty="LUX" if s003a==442
replace cty="MLT" if s003a==470
replace cty="MEX" if s003a==484
replace cty="MDA" if s003a==498
replace cty="MAR" if s003a==504
replace cty="NLD" if s003a==528
replace cty="NZL" if s003a==554
replace cty="NGA" if s003a==566
replace cty="NOR" if s003a==578
replace cty="PAK" if s003a==586
replace cty="PER" if s003a==604
replace cty="PHL" if s003a==608
replace cty="POL" if s003a==616
replace cty="PRT" if s003a==620
replace cty="PRI" if s003a==630
replace cty="ROM" if s003a==642  /*Is it ROM or ROU?*/
replace cty="RUS" if s003a==643
replace cty="SAU" if s003a==682
replace cty="SGP" if s003a==702
replace cty="SVK" if s003a==703
replace cty="VNM" if s003a==704
replace cty="SVN" if s003a==705
replace cty="ZAF" if s003a==710
replace cty="ZWE" if s003a==716
replace cty="ESP" if s003a==724
replace cty="SWE" if s003a==752
replace cty="CHE" if s003a==756
replace cty="TUR" if s003a==792
replace cty="UGA" if s003a==800
replace cty="UKR" if s003a==804
replace cty="MKD" if s003a==807
replace cty="EGY" if s003a==818
replace cty="GBR" if s003a==826
replace cty="TZA" if s003a==834
replace cty="USA" if s003a==840
replace cty="URY" if s003a==858
replace cty="VEN" if s003a==862
replace cty="DEU" if s003a==900 /* This is the code I use for West Germany (should be DEU) */
replace cty="DDR" if s003a==901 /* Actual code should be DDR */
replace cty="NIR" if s003a==909 /* There is no official code for Northern Ireland*/
replace cty="SRB" if s003a==911
replace cty="MNE" if s003a==912
replace cty="SRP" if s003a==913 /* Srpska is officially part of BIH - Bosnia and Herzogovnia */
replace cty="BSF" if s003a==914 /* Bosnian Federation is officially part of BIH - Bosnia and Herzogovnia */

replace cty="BIH" if cty=="SRP" | cty=="BSF" /* Combine them into Bosnia and Herzogovnia*/
replace cty="SCG" if cty=="SRB" | cty=="MNE" /* Combine Serbia and Montenegro */
replace cty="DEU" if cty=="DEU" | cty=="DDR" /* Combine East and West Germany into one country */

tab s003a if missing(cty)
assert !missing(s003a)

/* fill in for fifth wave countries not in previous waves */
replace cty = "AND" if s003a == 	20     /* Andorra should be AND  to agree with GDP */
replace cty = "CYP" if s003a == 	196
replace cty = "ETH" if s003a == 	231
replace cty = "GHA" if s003a == 	288
replace cty = "GTM" if s003a == 	320
replace cty = "HKG" if s003a == 	344
replace cty = "MYS" if s003a == 	458    /* Malaysia should be MYS to agree with GDP */
replace cty = "MLI" if s003a == 	466
replace cty = "RWA" if s003a == 	646
replace cty = "THA" if s003a == 	764
replace cty = "TTO" if s003a == 	780
replace cty = "BFA" if s003a == 	854
replace cty = "ZMB" if s003a == 	894

replace cty = "ROM" if s003a ==     642     /* Romania should be ROM to agree with GDP */


gen oecd=.
for X in any AUT BEL CAN DNK FRA DEU GRC ISL IRL ITA LUX NLD NOR PRT ESP SWE CHE TUR GBR USA JPN FIN AUS NZL MEX CZE KOR HUN POL SVK: replace oecd=1 if cty=="X"

assert !missing(cty)

gen str30 country=""
replace country="Albania" if s003a==8
replace country="Algeria" if s003a==12
replace country="Azerbaijan" if s003a==31
replace country="Argentina" if s003a==32
replace country="Australia" if s003a==36
replace country="Austria" if s003a==40
replace country="Bangladesh" if s003a==50
replace country="Armenia" if s003a==51
replace country="Belgium" if s003a==56
replace country="Brazil" if s003a==76
replace country="Bulgaria" if s003a==100
replace country="Belarus" if s003a==112
replace country="Canada" if s003a==124
replace country="Chile" if s003a==152
replace country="China" if s003a==156
replace country="Taiwan" if s003a==158
replace country="Colombia" if s003a==170
replace country="Croatia" if s003a==191
replace country="Czech Republic" if s003a==203
replace country="Denmark" if s003a==208
replace country="Dominican Republic" if s003a==214
replace country="El Salvador" if s003a==222
replace country="Estonia" if s003a==233
replace country="Finland" if s003a==246
replace country="France" if s003a==250
replace country="Georgia" if s003a==268
replace country="Greece" if s003a==300
replace country="Hungary" if s003a==348
replace country="Iceland" if s003a==352
replace country="India" if s003a==356
replace country="Indonesia" if s003a==360
replace country="Iran (Islamic Republic Of)" if s003a==364
replace country="Iraq" if s003a==368
replace country="Ireland" if s003a==372
replace country="Israel" if s003a==376
replace country="Italy" if s003a==380
replace country="Japan" if s003a==392
replace country="Jordan" if s003a==400
replace country="South Korea" if s003a==410
replace country="Kyrgyzstan" if s003a==417
replace country="Latvia" if s003a==428
replace country="Lithuania" if s003a==440
replace country="Luxembourg" if s003a==442
replace country="Malta" if s003a==470
replace country="Mexico" if s003a==484
replace country="Moldova" if s003a==498
replace country="Morocco" if s003a==504
replace country="Netherlands" if s003a==528
replace country="New Zealand" if s003a==554
replace country="Nigeria" if s003a==566
replace country="Norway" if s003a==578
replace country="Pakistan" if s003a==586
replace country="Peru" if s003a==604
replace country="Philippines" if s003a==608
replace country="Poland" if s003a==616
replace country="Portugal" if s003a==620
replace country="Puerto Rico" if s003a==630
replace country="Romania" if s003a==642
replace country="Russia" if s003a==643
replace country="Saudi Arabia" if s003a==682
replace country="Singapore" if s003a==702
replace country="Slovakia" if s003a==703
replace country="Viet Nam" if s003a==704
replace country="Slovenia" if s003a==705
replace country="South Africa" if s003a==710
replace country="Zimbabwe" if s003a==716
replace country="Spain" if s003a==724
replace country="Sweden" if s003a==752
replace country="Switzerland" if s003a==756
replace country="Turkey" if s003a==792
replace country="Uganda" if s003a==800
replace country="Ukraine" if s003a==804
replace country="Macedonia" if s003a==807
replace country="Egypt" if s003a==818
replace country="Great Britain" if s003a==826
replace country="Tanzania" if s003a==834
replace country="United States" if s003a==840
replace country="Uruguay" if s003a==858
replace country="Venezuela" if s003a==862
replace country="West Germany" if s003a==900
replace country="East Germany" if s003a==901
replace country="Northern Ireland" if s003a==909
replace country="Serbia" if s003a==911
replace country="Montenegro" if s003a==912
replace country="Srpska" if s003a==913
replace country="Bosnia Federation" if s003a==914

replace country="Bosnia & Herzegovina" if cty=="BIH"
replace country="Germany" if cty=="DEU"
replace country="Serbia & Montenegro" if cty=="SCG"

/* Fill in country for wave 5 guys not in older survey */
replace country = "Andorra" if s003a == 	20
replace country = "Cyprus" if s003a == 	196
replace country = "Ethiopia" if s003a == 	231
replace country = "Ghana" if s003a == 	288
replace country = "Guatemala" if s003a == 	320
replace country = "Hong Kong" if s003a == 	344
replace country = "Malaysia" if s003a == 	458
replace country = "Mali" if s003a == 	466
replace country = "Rwanda" if s003a == 	646
replace country = "Thailand" if s003a == 	764
replace country = "Trinidad and" if s003a == 	780
replace country = "Burkina Faso" if s003a == 	854
replace country = "Zambia" if s003a == 	894


* My variables
gen year=s020
gen sex=x001
gen wt=s017a
gen wt1000=s018a
gen wave=.
for X in num 1/5 \ Y in num 1982 1990 1996 2000 2005: replace wave=Y if s002==X

gen sat=a170
gen hap=5-a008
gen freedom=a173
gen jobsat=c033

for X in var a010-a019 \ Y in any excited restless proud lonely pleased bored topoftheworld depressed goingmyway upset: gen feeling_Y=X 

gen age=x003
gen marital=x007
gen kids=x011

label define waves 1982 "1981-84 wave" 1990 "1989-93 wave" 1996 "1994-99 wave" 2000 "1999-2004 wave" 2005 "2005-2008 wave"
label values wave waves

* Add a marker for non-representative national samples (where there are no weights to correct this).
gen nonrepresentative=0
replace nonrepresentative=1 if cty=="ARG" & (wave==1982 | wave==1990 | wave==1996)
replace nonrepresentative=1 if cty=="BGD" & (wave==1996)
replace nonrepresentative=1 if cty=="CHL" & (wave==1990 | wave==1996 | wave == 2005)
replace nonrepresentative=2 if cty=="CHL" & (wave==2000)
replace nonrepresentative=1 if cty=="CHN" & (wave==1990)
replace nonrepresentative=2 if cty=="CHN" & (wave==1996)
replace nonrepresentative=1 if cty=="DOM" & (wave==1996)
replace nonrepresentative=1 if cty=="EGY" & (wave==2000)
replace nonrepresentative=1 if cty=="IND" & (wave==1990)
replace nonrepresentative=2 if cty=="IND" & (wave==1996)
replace nonrepresentative=1 if cty=="MEX" & (wave==1990)
replace nonrepresentative=1 if cty=="NGA" & (wave==1990)
replace nonrepresentative=2 if cty=="NGA" & (wave==1996)
replace nonrepresentative=1 if cty=="PAK" & (wave==1996)
replace nonrepresentative=1 if cty=="ZAF" & (wave==1990)

/************************************************************************************************/
/* Fixing Northern Ireland                                                                      */
/* For both WVS and for EB, (and probably other data sets), I think the best thing to do        */
/* is take the weights for NIR and for GBR, and rescale them so that the relative weight        */
/* of each is proportional to its share of the population, and so that the sum of the weights   */
/* is equal to GBR's initial sum of weights.                                                    */
/************************************************************************************************/

/********************************************************************/
/* note that I treat the population of the UK and NIR as a local    */
/* UK population in 2008: 61398.2 (thousands)                       */
/* UK population in 2009: 61792.0 (thousands)                       */
/* Source: www.statistics.gov.uk                                    */
/*                                                                  */
/* UK population data otherwise come from pwt                       */
/* NIR population data come from nisra.gov.uk                       */
/********************************************************************/


/****************************/
/* Load the population data */
/****************************/

replace year = int(year)
capture sum pop
merge m:1 cty year using "$directory/gdp/Complete_GDP", keepusing(pop) keep(master match match_update)
drop _merge
replace pop = 61398.2 if year == 2008 & cty == "GBR"
replace pop = 61792.0 if year == 2009 & cty == "GBR"
merge m:1 cty year using "$directory/gdp/Raw/nir", keepusing(pop) update keep(master match match_update)
tab _m
drop _merge

gen nir = (cty=="NIR")
levelsof year if cty == "NIR", local(years)
foreach year of local years{
    /* get populations for the year */
    sum pop if cty == "NIR" & year==`year'
    local popNIR = r(mean)
    sum pop if cty == "GBR" & year == `year'
    local popUK = r(mean)
    
    /* get total weight for GBR */
    sum wt if cty == "GBR" & year == `year'
    local oldSum = r(N)*r(mean)
    
    /* Step 1: get ratios right, adjusting for differences in total weights */
    sum wt if cty == "NIR" & year == `year'
    replace wt = wt *(`popNIR'/`popUK')/(r(mean)*r(N)) if cty == "NIR" & year == `year'
    sum wt if cty == "GBR" & year == `year'
    replace wt = wt *(1-`popNIR'/`popUK')/(r(mean)*r(N)) if cty == "GBR" & year == `year'
        
    /* Step 2: fold NIR into GBR */
    replace cty = "GBR" if cty == "NIR" & year == `year'
    
    /* Step 3: get the the total weight right */
    sum wt if cty == "GBR" & year == `year'
    replace wt = wt*`oldSum'/(r(N)*r(mean)) if cty == "GBR" & year == `year'
    
}
drop pop /* note that the pop variable isn't even correct anymore */
table year if cty == "GBR" [aw=wt], c(freq mean nir)
table year if cty == "GBR", c(freq mean nir)

* Merge in GDP data
merge m:1 cty year using "$directory/gdp/Complete_GDP.dta", keep(master match match_update)
tab cty if _merge==1
set matsize 2000
reg gdp i.ctyid##i.wave [aw=wt1000]
predict gdpav if gdp~=.
drop gdp
rename gdpav gdp
la var gdp "GDP per capita at PPP"

egen ctywve=group(cty wave)
/* This is the individual income variables, which need to be updated for the fifth wave
 do "$directory/Justin/WVS/WVS income coding.do"
xi: reg inc i.s024a [pw=wt]
predict inchat if inc~=.
tomode inchat, by(s024a) replace
xi: reg lninc i.s024a [pw=wt]
predict lninchat if lninc~=.
tomode lninchat, by(s024a) replace
gen mld=ln(inchat)-lninchat
xi: reg mld i.ctywve [pw=wt]
predict mldav if mld~=.
tomode mldav, by (ctywve) replace
drop mld inchat lninchat
rename mldav mld
*/

* Add in controls
replace age=-1 if age==.
gen age_missing=age==-1
forvalues x=1/4{
    gen age`x' = age^`x' 
    gen fage`x' = age`x'*(sex==2)
}
replace sex=-1 if sex==.
gen sex_missing=(sex==-1)
global controls "age1-age4 fage1-fage4 sex sex_missing age_missing"

gen exclude = missing(cty) | missing(gdp) | missing(wave) | nonrepresentative==1
foreach var of varlist $controls{
    replace exclude = 1 if missing(`var')
}

/* Make a standardized variable */
foreach swb in sat hap {

    sum `swb'  [aw=wt] if !exclude
    local mean = r(mean)
    gen `swb'_z_all = (`swb'-r(mean))/r(sd) if !exclude
	local lb: var lab `swb'
	la var `swb'_z_all "`lb' (standardized)"
    
    qui reg `swb' i.ctyid i.wave [aw=wt] if !exclude
    predict `swb'_res if !exclude, res
    summ `swb'_res [aw=wt] if !exclude
	local sd=`r(sd)'
    gen `swb'_z = (`swb'-`mean')/`sd'
	char `swb'_z[mean] "`mean'"
	char `swb'_z[sd] "`sd'"
	la var `swb'_z "`lb' (standardized | cty & wave)"
	drop `swb'_res
    
    /* Make mean and SD, for help later */
    gen `swb'_sd_residuals = r(sd)
}



/* Make a country-mean of SWB, not standardized, for comparison to Easterlin */
reg sat i.ctywve [pw=wt]
predict sat_level_hat if !missing(sat), xb
tomode sat_level_hat, by(ctywve) replace

compress

gen nsat=1 if !missing(sat) & nonrep==0
gen nhap=1 if !missing(hap) & nonrep==0
foreach v of varlist *_z { /*Make sure that characteristics survive being collapsed */
 	local `v'mean: char `v'[mean]
	local `v'sd : char `v'[sd]
}

collapse (mean) sat* hap* nonrepresentative oecd *nemployment* *inflation* *gap* *gdp* year ctyid (sum) nhap nsat [aw=wt], by(cty wave)
foreach v of varlist *_z {
	char `v'[mean] "``v'mean'"
	char `v'[sd] "``v'sd'"
}
save "$directory/WVS/WVS_macro.dta", replace
